<?php
// fetch_hq_log.php
header('Content-Type: application/json');

// TEMP: show errors while we debug (remove in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// 1) Connect to DB (same pattern as hq_log_message.php)
$cfgPath = '/var/www/html/orgs/kh-races_dev/ray-miller-50-50/config.race.php';
$cfg = include $cfgPath;

$conn = new mysqli($cfg['host'], $cfg['username'], $cfg['password'], $cfg['dbname']);
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'DB connect failed: ' . $conn->connect_error]);
    exit;
}

// 2) Optional filters from query string
$ackFilter = isset($_GET['ack']) ? trim($_GET['ack']) : '';         // '', 'pending', 'ack'
$station   = isset($_GET['station']) ? trim($_GET['station']) : ''; // '', 'ALL', 'AS1', etc.
$limit     = isset($_GET['limit']) ? (int)$_GET['limit'] : 100;
if ($limit <= 0 || $limit > 500) {
    $limit = 100;
}

// 3) Build WHERE conditions
$where = [];
$params = [];
$types = '';

if ($station !== '' && strtoupper($station) !== 'ALL') {
    $where[]  = '(station_target = ? OR station_target = "ALL")';
    $params[] = $station;
    $types   .= 's';
}

if ($ackFilter === 'pending') {
    $where[] = 'acknowledged = 0';
} elseif ($ackFilter === 'ack') {
    $where[] = 'acknowledged = 1';
}

$whereSql = '';
if (count($where) > 0) {
    $whereSql = 'WHERE ' . implode(' AND ', $where);
}

// 4) Fetch recent messages (newest first)
$sql = "
    SELECT
        id,
        event_id,
        station_target,
        channel,
        message_text,
        operator,
        msg_number,
        acknowledged,
        ack_time,
        created_at
    FROM hq_messages
    $whereSql
    ORDER BY created_at DESC
    LIMIT ?
";

$params[] = $limit;
$types   .= 'i';

$stmt = $conn->prepare($sql);
if (!$stmt) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Prepare failed: ' . $conn->error]);
    exit;
}

$stmt->bind_param($types, ...$params);

if (!$stmt->execute()) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Execute failed: ' . $stmt->error]);
    $stmt->close();
    $conn->close();
    exit;
}

$result = $stmt->get_result();
$messages = [];

while ($row = $result->fetch_assoc()) {
    $messages[] = $row;
}

$stmt->close();
$conn->close();

echo json_encode([
    'success'  => true,
    'messages' => $messages
]);
