<?php
// fetch_hq_messages.php
// Used by aid station pages to pull NEW, PENDING messages from HQ

header('Content-Type: application/json');

// TEMP: show errors while we debug (remove in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// 1) Connect to DB
$cfgPath = '/var/www/html/orgs/kh-races_dev/ray-miller-50-50/config.race.php';
$cfg = include $cfgPath;

$conn = new mysqli($cfg['host'], $cfg['username'], $cfg['password'], $cfg['dbname']);
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'DB connect failed: ' . $conn->connect_error]);
    exit;
}

// 2) Read query parameters
$station = isset($_GET['station']) ? trim($_GET['station']) : '';
if ($station === '') {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Missing station parameter']);
    exit;
}

// We will return ONLY messages that:
// - are targeted to this station OR to ALL
// - are NOT acknowledged yet (acknowledged = 0)
$limit = 50;

$sql = "
    SELECT
        id,
        event_id,
        station_target,
        channel,
        message_text,
        operator,
        msg_number,
        acknowledged,
        ack_time,
        created_at
    FROM hq_messages
    WHERE
        (station_target = ? OR station_target = 'ALL')
        AND acknowledged = 0
    ORDER BY id ASC
    LIMIT ?
";

$stmt = $conn->prepare($sql);
if (!$stmt) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Prepare failed: ' . $conn->error]);
    exit;
}

$stmt->bind_param("si", $station, $limit);

if (!$stmt->execute()) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'Execute failed: ' . $stmt->error]);
    $stmt->close();
    $conn->close();
    exit;
}

$result = $stmt->get_result();
$messages = [];

while ($row = $result->fetch_assoc()) {
    $messages[] = $row;
}

$stmt->close();
$conn->close();

echo json_encode([
    'success'  => true,
    'messages' => $messages
]);
