<?php
// hq_log_message.php
header('Content-Type: application/json');

// TEMP: show errors while we debug (remove later in production)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// 1) Connect to the same DB as submit_bib.1.3.3.php
$cfgPath = '/var/www/html/orgs/kh-races_dev/ray-miller-50-50/config.race.php';
$cfg = include $cfgPath;

$conn = new mysqli($cfg['host'], $cfg['username'], $cfg['password'], $cfg['dbname']);
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(['success' => false, 'error' => 'DB connect failed: ' . $conn->connect_error]);
    exit;
}

// 2) Read JSON body
$raw = file_get_contents('php://input');
$data = json_decode($raw, true);

if (!is_array($data)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Invalid JSON']);
    exit;
}

$event_id       = isset($data['event_id']) ? trim($data['event_id']) : '';
$station_target = isset($data['station_target']) ? trim($data['station_target']) : '';
$channel        = isset($data['channel']) ? trim($data['channel']) : '';
$message_text   = isset($data['message_text']) ? trim($data['message_text']) : '';
$operator       = isset($data['operator']) ? trim($data['operator']) : '';
$msg_number     = isset($data['msg_number']) && $data['msg_number'] !== '' ? (int)$data['msg_number'] : null;

// Basic validation
if ($station_target === '' || $channel === '' || $message_text === '') {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error'   => 'Missing required fields (station_target, channel, message_text)'
    ]);
    exit;
}

try {
    $stmt = $conn->prepare("
        INSERT INTO hq_messages
            (event_id, station_target, channel, message_text, operator, msg_number)
        VALUES (?, ?, ?, ?, ?, ?)
    ");

    if (!$stmt) {
        throw new Exception('Prepare failed: ' . $conn->error);
    }

    // msg_number is nullable → use i or null
    $stmt->bind_param(
        "sssssi",
        $event_id,
        $station_target,
        $channel,
        $message_text,
        $operator,
        $msg_number
    );

    if (!$stmt->execute()) {
        throw new Exception('Execute failed: ' . $stmt->error);
    }

    $insert_id = $stmt->insert_id;
    $stmt->close();
    $conn->close();

    echo json_encode([
        'success' => true,
        'id'      => $insert_id
    ]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error'   => $e->getMessage()
    ]);
}

