<?php
// load_bib.1.3.3.php - NOW RETURNS LOG ENTRIES LIKE tracker_api.php
$origin = $_SERVER['HTTP_ORIGIN'] ?? '';
$allowed = [
    'https://tvemcdb.tail37eb46.ts.net',
    'http://localhost',
    'http://127.0.0.1'
];
if ($origin && in_array($origin, $allowed)) {
    header("Access-Control-Allow-Origin: $origin");
} else {
    header("Access-Control-Allow-Origin: *");
}
header('Access-Control-Allow-Methods: GET');
header('Content-Type: application/json');

$race = $_GET['race'] ?? '/orgs/kh-races_dev/ray-miller-50-50';
$configFile = '/var/www/html' . $race . '/config.race.php';
if (!file_exists($configFile)) {
    $configFile = '/var/www/html/config.1.3.3.php';
}
if (!file_exists($configFile)) {
    http_response_code(500);
    echo json_encode(['error' => 'No config']);
    exit;
}

$config = include $configFile;
$conn = new mysqli($config['host'], $config['username'], $config['password'], $config['dbname']);
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(['error' => 'DB error']);
    exit;
}

// NOW RETURNS LOG ENTRIES - SAME AS tracker_api.php
$limit = isset($_GET['limit']) ? max(1, (int)$_GET['limit']) : 500;
$stmt = $conn->prepare("SELECT * FROM bib_data ORDER BY id DESC LIMIT ?");
$stmt->bind_param('i', $limit);
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_all(MYSQLI_ASSOC);

// 🔹 Add a 'date' field for the app, using today's date (same behavior as finish_lookup)
$today = date('n/j/Y'); // e.g. 12/3/2025
foreach ($data as &$row) {
    // If a date field already exists and is non-empty, keep it.
    // Otherwise, set it to today's date.
    if (!isset($row['date']) || $row['date'] === '' || $row['date'] === 'N/A') {
        $row['date'] = $today;
    }
}
unset($row); // end reference

echo json_encode($data);
$conn->close();
?>
