<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');

$cfgPath = '/var/www/html/orgs/kh-races_dev/ray-miller-50-50/config.race.php';
$cfg = include $cfgPath;

$conn = new mysqli($cfg['host'], $cfg['username'], $cfg['password'], $cfg['dbname']);
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(['error' => 'DB connect failed: '.$conn->connect_error]);
    exit;
}

$sql = "
  SELECT id,
         aid_station,
         comment,
         operator,
         event_name,
         message_num,
         timestamp
  FROM general_message_log
  ORDER BY id DESC
";
$result = $conn->query($sql);

$data = [];
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }
}
echo json_encode($data);

$conn->close();
?>
