window.sendInternetToSelected = async function () {
  const targetEl = document.getElementById("hqTarget");
  const textEl = document.getElementById("hqMessageText");
  const hqStatus = document.getElementById("hqStatus");

  const target = targetEl ? targetEl.value : "ALL";
  const text = (textEl ? textEl.value : "").trim();

  if (!text) {
    alert("Type a message first");
    return;

  }

  // You may already have event info and operator somewhere on the page.
  // These are safe fallbacks:
  const eventId =
    (window.TVEMC_EVENT_ID || "").toString().trim(); // optional global
  const operator =
    (document.getElementById("operatorName")?.value || "").trim();

  // 1) Log to server
  if (hqStatus) hqStatus.textContent = "Sending Internet message...";

  const result = await logHqMessageToServer({
    event_id: eventId,
    station_target: target,
    channel: "internet",
    message_text: text,
    operator: operator || "",
    msg_number: null // we can add a separate HQ msg counter later if you want
  });

  if (!result.success) {
    if (hqStatus) {
      hqStatus.textContent = "Error sending Internet message";
      setTimeout(() => {
        hqStatus.textContent = "Status: Ready";
      }, 4000);
    }
    alert("Could not log Internet HQ message: " + (result.error || "Unknown error"));
    return;
  }

// 🔹 1) Helper to POST HQ messages to the server
async function logHqMessageToServer(payload) {
  try {
    const response = await fetch('hq_log_message.php', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json'
      },
      body: JSON.stringify(payload)
    });

    if (!response.ok) {
      console.error('Log HQ message HTTP error', response.status);
      return { success: false, error: 'HTTP ' + response.status };
    }

    const data = await response.json();
    if (!data.success) {
      console.error('Log HQ message API error', data.error);
    }
    return data;
  } catch (err) {
    console.error('Log HQ message fetch error', err);
    return { success: false, error: err.message };
  }
}

// 🔹 2) The function your button calls
window.sendInternetToSelected = async function () {
  const targetEl = document.getElementById("hqTarget");
  const textEl = document.getElementById("hqMessageText");
  const hqStatus = document.getElementById("hqStatus");

  const target = targetEl ? targetEl.value : "ALL";
  const text = (textEl ? textEl.value : "").trim();

  if (!text) {
    alert("Type a message first");
    return;
  }

  // Optional: grab event/operator if you have them
  const eventId = (window.TVEMC_EVENT_ID || "").toString().trim();
  const operator =
    (document.getElementById("operatorName")?.value || "").trim();

  if (hqStatus) hqStatus.textContent = "Sending Internet message...";

  // 🔹 Log to server
  const result = await logHqMessageToServer({
    event_id: eventId,
    station_target: target,
    channel: "internet",
    message_text: text,
    operator: operator || "",
    msg_number: null
  });

  if (!result.success) {
    if (hqStatus) {
      hqStatus.textContent = "Error sending Internet message";
      setTimeout(() => {
        hqStatus.textContent = "Status: Ready";
      }, 4000);
    }
    alert("Could not log Internet HQ message: " + (result.error || "Unknown error"));
    return;
  }

  // Clear input
  if (textEl) textEl.value = "";

  if (hqStatus) {
    hqStatus.textContent = "Internet message logged!";
    setTimeout(() => {
      hqStatus.textContent = "Status: Ready";
    }, 3000);
  }

  console.log("Internet HQ message logged with id:", result.id);
};


  // 2) (Later) also push this to station inbox via polling/fetch

  // Clear text box
  if (textEl) textEl.value = "";

  if (hqStatus) {
    hqStatus.textContent = "Internet message logged!";
    setTimeout(() => {
      hqStatus.textContent = "Status: Ready";
    }, 3000);
  }

  console.log("Internet HQ message logged with id:", result.id);
};
