<?php
header("Content-Type: application/json");

// ---- Load DB Config ----
$cfgPath = __DIR__ . "/config.race.php";
$cfg = include $cfgPath;

// ---- Connect ----
$conn = new mysqli($cfg['host'], $cfg['username'], $cfg['password'], $cfg['dbname']);
if ($conn->connect_error) {
    echo json_encode(["success" => false, "error" => "DB Connect Failed"]);
    exit;
}
$conn->set_charset("utf8mb4");

// ---- Read Payload ----
$payload = $_POST;
if (!$payload) {
    $raw = file_get_contents("php://input");
    if ($raw) {
        $tmp = json_decode($raw, true);
        if (is_array($tmp)) {
            $payload = $tmp;
        }
    }
}

$bib       = isset($payload["bib"]) ? intval($payload["bib"]) : 0;
$status    = trim($payload["status"] ?? "");
$distance  = trim($payload["distance"] ?? "");
$previous  = trim($payload["previous_distance"] ?? "");

if ($bib <= 0) {
    echo json_encode(["success" => false, "error" => "Bib required"]);
    exit;
}

// ---- Runner info we want to populate ----
$firstName = null;
$lastName  = null;
$age       = null;
$gender    = null;

// ---- Look up this bib in runner_import (CSV-derived table) ----
$regSql = "
    SELECT first_name, last_name, age, gender, distance AS reg_distance, previous_distance AS reg_prev
    FROM runner_import
    WHERE bib = ?
    LIMIT 1
";
$regStmt = $conn->prepare($regSql);
if ($regStmt) {
    $regStmt->bind_param("i", $bib);
    if ($regStmt->execute()) {
        $regRes = $regStmt->get_result();
        if ($regRes && $regRes->num_rows > 0) {
            $reg = $regRes->fetch_assoc();

            if (!empty($reg["first_name"])) {
                $firstName = $reg["first_name"];
            }
            if (!empty($reg["last_name"])) {
                $lastName = $reg["last_name"];
            }
            if (!empty($reg["gender"])) {
                $gender = $reg["gender"];
            }
            if ($reg["age"] !== null && $reg["age"] !== "") {
                $age = (int)$reg["age"];
            }

            // If payload didn't specify distance/previous, use registry values
            if ($distance === "" && !empty($reg["reg_distance"])) {
                $distance = $reg["reg_distance"];
            }
            if ($previous === "" && !empty($reg["reg_prev"])) {
                $previous = $reg["reg_prev"];
            }
        }
    }
    $regStmt->close();
}

// ---- Final safety: allow empty strings if we truly don't know ----
if ($distance === "") {
    $distance = "";
}
if ($previous === "") {
    $previous = "";
}

// ---- Insert the Log Entry with runner info ----
// Make sure bib_data has columns: first_name, last_name, age, gender, distance, previous_distance
$sql = "
    INSERT INTO bib_data
        (bib, status, first_name, last_name, age, gender, distance, previous_distance)
    VALUES
        (?, ?, ?, ?, ?, ?, ?, ?)
";
$stmt = $conn->prepare($sql);
if (!$stmt) {
    echo json_encode(["success" => false, "error" => "Prepare failed"]);
    exit;
}

// Types: i = int, s = string
// bib (i), status (s), first_name (s), last_name (s), age (i), gender (s), distance (s), previous (s)
$stmt->bind_param(
    "isssisss",
    $bib,
    $status,
    $firstName,
    $lastName,
    $age,
    $gender,
    $distance,
    $previous
);
$stmt->execute();

if ($stmt->error) {
    echo json_encode(["success" => false, "error" => "Execute failed"]);
    exit;
}

echo json_encode(["success" => true, "id" => $stmt->insert_id]);
?>
