<?php

header("Access-Control-Allow-Origin: https://tvemcdb.tail37eb46.ts.net");
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

// Handle preflight
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Load dev config early to set headers
$race = $_POST['race'] ?? '/orgs/kh-races_dev/ray-miller-50-50';
$configFile = '/var/www/html' . $race . '/config.race.php';
if (file_exists($configFile)) {
    $cfg = include $configFile;
    if (!empty($cfg['origins'])) {
        header("Access-Control-Allow-Origin: " . implode(',', $cfg['origins']));
    } else {
        header("Access-Control-Allow-Origin: *");
    }
}
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    exit(json_encode(['success' => false, 'error' => 'Invalid request method']));
}

$data = json_decode(file_get_contents('php://input'), true);

$aidStation = trim($data['aidStation'] ?? '');
$comment    = trim($data['comment'] ?? '');
$operator   = trim($data['operator'] ?? 'Unknown');
$eventName  = trim($data['eventName'] ?? 'Ray Miller 50-50');
$messageNum = intval($data['messageNum'] ?? 1);

if (!$comment) {
    exit(json_encode(['success' => false, 'error' => 'Missing comment']));
}

$race = $data['race'] ?? '/orgs/kh-races_dev/ray-miller-50-50';
$configFile = '/var/www/html' . $race . '/config.race.php';
if (!file_exists($configFile)) {
    $configFile = '/var/www/html/config.1.3.3.php';
}
if (!file_exists($configFile)) {
    exit(json_encode(['success' => false, 'error' => 'No config file found']));
}

$config = include $configFile;

$conn = new mysqli($config['host'], $config['username'], $config['password'], $config['dbname']);
if ($conn->connect_error) {
    exit(json_encode(['success' => false, 'error' => 'DB connect failed: ' . $conn->connect_error]));
}

// --- Corrected placeholders and variable name ---
$stmt = $conn->prepare(
  "INSERT INTO general_message_log
   (aid_station, comment, operator, event_name, message_num)
   VALUES (?, ?, ?, ?, ?)"
);
$stmt->bind_param("ssssi", $aidStation, $comment, $operator, $eventName, $messageNum);
$success = $stmt->execute();

if (!$success) {
    echo json_encode(['success' => false, 'error' => $stmt->error]);
} else {
    echo json_encode(['success' => true]);
}

$stmt->close();
$conn->close();
?>
